/*=============================================================================
 MessageWindowPopup_KuroCustom.js 
----------------------------------------------------------------------------

/*:
 * @plugindesc フキダシウィンドウプラグイン くろあめ工房カスタム
 * @author くろあめ
 * @target MZ
 *
 * @help トリアコンタンさんのフキダシウィンドウプラグインを
 * くろあめ工房製のドットフェイスに合わせて改造します。
 */

(() => {

    //=============================================================================
    // ImageManager
    //  ポップアップ用のフェイスグラフィックサイズを設定します。
    //=============================================================================
    ImageManager.popUpfaceWidth  = 90;
    ImageManager.popUpfaceHeight = 90;

    const _Window_Message_processVirtual   = Window_Message.prototype.processVirtual;
    Window_Message.prototype.processVirtual = function() {
        _Window_Message_processVirtual.apply(this, arguments);
        if (this.isPopup() && $gameMessage.faceName() != '') {
            this.width += ImageManager.popUpfaceWidth + 8;
        }
    };

    const _Window_Message_newLineX    = Window_Message.prototype.newLineX;
    Window_Message.prototype.newLineX = function() {
        if (this.isPopup()) {
/* add Start */
            //return $gameMessage.faceName() === '' ? 0 : ImageManager.popUpfaceWidth + 8;
            return 0;
/* add End */
        } else {
            return _Window_Message_newLineX.apply(this, arguments);
        }
    };

    const _Window_Message_drawFace2 = Window_Base.prototype.drawFace;
    Window_Message.prototype.drawFace = function(faceName, faceIndex, x, y, width, height) {
        if (this.isPopup()) {
            arguments[4] = ImageManager.faceWidth;
            arguments[5] = ImageManager.faceHeight;
/* add Start */
            this.contents.prepareDwDh(144, 144);//this.contents.prepareDwDh(ImageManager.popUpfaceWidth, ImageManager.popUpfaceHeight); //KURO Custom
/* add End */
        }
/* add Start */
        arguments[2] = this.width - ImageManager.popUpfaceWidth - 20 ;
/* add End */
        _Window_Message_drawFace2.apply(this, arguments);
    };

})();
